import java.rmi.RemoteException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SwingWorkerStub implements ChatServer {
    ChatServer stub;
    ChatDemo app;

    /** @link dependency */
    /*# SwingWorker lnkSwingWorker; */    

    public SwingWorkerStub(ChatServer stub, ChatDemo app) {
        this.stub = stub;
        this.app = app;
    }
    
    public int sendMessage(final String msg) throws RemoteException {
        if (SwingUtilities.isEventDispatchThread()) {
            Object response = null;
            SwingWorker worker = new SwingWorker() {
                int nusers = -1;
                Exception exception = null;
                public Object construct() {
                    try {
                        return stub.sendMessage(msg);
                    } catch (RemoteException e) {
                        this.exception = e;
                        return nusers;
                    }
                }
                
                public void finished() {
                    if (this.exception == null ) {
                        System.out.println("here 1");
                        nusers = (Integer)this.getValue();
                        app.addMessage("Message = \"" + msg +
                                "\"sent to " + nusers + " users");
                    } else {
                        JOptionPane.showMessageDialog(
                                app,this.exception.getMessage(),
                                "Error Sending Message",JOptionPane.ERROR_MESSAGE);
                    }
                    app.setBusy(false);
                    app.stopTimer();
                }
            };
            worker.start();
        }
        return 0;
    }

	public void addChatListener(ChatListener chatListener) {
	}
}
