import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import foxtrot.Worker;
import foxtrot.Task;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.swing.SwingUtilities;

public class FoxTrotStubFactory {
    public static ChatServer create(ChatServer stub) {
        ClassLoader loader = FoxTrotStubFactory.class.getClassLoader();
        FoxTrotHandler handler = new FoxTrotHandler(stub);
        ChatServer foxTrotStub = (ChatServer) Proxy.newProxyInstance(
                loader, new Class[] {ChatServer.class},handler);
                return foxTrotStub;
    }
}

class FoxTrotHandler implements InvocationHandler {
    ChatServer stub;
    
    public FoxTrotHandler(ChatServer stub) {
        this.stub = stub;
    }
    
    public Object invoke(final Object proxy,
            final Method method, final Object[] args) throws RemoteException {
        if (SwingUtilities.isEventDispatchThread()) {
            Object response = null;
            try {
                response = Worker.post(new Task() {
                    public Object run() throws RemoteException,
                            IllegalAccessException,InvocationTargetException {
                        return method.invoke(stub,args);
                    }
                });
            } catch (Exception e) {
                throw new RemoteException(e.getMessage(),e);
            }
            return (Integer) response;
        } else {
            try {
                return method.invoke(stub,args);
            } catch (Exception e) {
                throw new RemoteException(e.getMessage(),e);
            }
        }
    }
}