import foxtrot.Task;
import foxtrot.Worker;
import java.rmi.RemoteException;
import javax.swing.SwingUtilities;

public class FoxTrotStub implements ChatServer {
    ChatServer stub;
    
    public FoxTrotStub(ChatServer stub) {
        this.stub = stub;
    }
    
    public int sendMessage(final String msg) throws RemoteException {
        if (SwingUtilities.isEventDispatchThread()) {
            Object response = null;
            try {
                response = Worker.post(new Task() {
                    public Object run() throws RemoteException {
                        return stub.sendMessage(msg);
                    }
                });
            } catch (Exception e) {
                throw new RemoteException(e.getMessage(),e);
            }
            return (Integer) response;
        } else {
            return stub.sendMessage(msg);
        }
    }
    public void addChatListener(ChatListener listener) {
    }
}