import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ChatListenerNotifierFactory {

	public static ChatListener createChatListenerNotifier(List listeners) {
		ChatNotifierHandler notifier = new ChatNotifierHandler(listeners);
		ClassLoader loader = ChatListenerNotifierFactory.class.getClassLoader();
		ChatListener listener = (ChatListener) Proxy.newProxyInstance(loader,
			new Class[] {ChatListener.class}
			, notifier);
		return listener;
	}
}

class ChatNotifierHandler implements InvocationHandler {
	List listeners = new LinkedList();

	ChatNotifierHandler(List listeners) {
		this.listeners = listeners;
	}

	public Object invoke(Object proxy, final Method method, final Object[] args) {
		synchronized (listeners) {
			Iterator iterator = listeners.iterator();
			while (iterator.hasNext()) {
				final Object o = iterator.next();
				if (o instanceof ChatListener) {
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							try {
								method.invoke( (ChatListener) o, args);
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});

				}
			}
			return null;
		}
	}
}
