import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ChatDemo extends javax.swing.JPanel {
    ChatServer serverStub;
    Timer timer;
    
    public ChatDemo(ChatServer serverStub) {
        this.serverStub = serverStub;
        initComponents();
    }
    
    public ChatDemo() {
        initComponents();
    }
    
    public void setChatServer(ChatServer serverStub) {
        this.serverStub = serverStub;
    }
    
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        sendButton = new javax.swing.JButton();
        scrollpane = new javax.swing.JScrollPane();
        messagesWidget = new javax.swing.JTextArea();
        messageWidget = new javax.swing.JTextField();
        clearButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        sendButton.setText("Send");
        sendButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(sendButton, gridBagConstraints);

        scrollpane.setViewportView(messagesWidget);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(scrollpane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(messageWidget, gridBagConstraints);

        clearButton.setText("Clear");
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(clearButton, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
        this.messagesWidget.setText("");
    }//GEN-LAST:event_clearButtonActionPerformed
    
    private void sendButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendButtonActionPerformed
        
        this.setBusy(true);
        String msg = this.messageWidget.getText();
        this.startTimer();
        
        if (! (this.serverStub instanceof SwingWorkerStub)) {
            try {
                int nusers = this.serverStub.sendMessage(msg); // server call
                this.addMessage("Message = \"" + msg +
                        "\"sent to " + nusers + " users");
            } catch (RemoteException e) {
                JOptionPane.showMessageDialog(this,e.getMessage(),
                        "Error Sending Message",JOptionPane.ERROR_MESSAGE);
            } finally {
                this.setBusy(false);
                this.stopTimer();
            }
        } else {
            try {
                this.serverStub.sendMessage(msg); // server call
            } catch (Exception e) {}
        }
    }//GEN-LAST:event_sendButtonActionPerformed
    
    public void startTimer() {
        this.timer = new Timer(1000,new ActionListener() {
            private int ntimes = 0;
            public void actionPerformed(ActionEvent evt) {
                ntimes++;
                ChatDemo.this.addMessage(
                        "Waiting " + ntimes + " seconds for a response...");
            }
        });
        this.timer.start();
    }
    
    public void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
        
    }
    
    public void setBusy(boolean busy) {
        Component c = SwingUtilities.getRoot(this);
        if (busy) {
            this.sendButton.setEnabled(false);
            c.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        } else {
            this.sendButton.setEnabled(true);
            c.setCursor(Cursor.getDefaultCursor());
        }
    }
    
    public void addMessage(String msg) {
        this.messagesWidget.insert(msg+"\n",0);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton clearButton;
    private javax.swing.JTextField messageWidget;
    private javax.swing.JTextArea messagesWidget;
    private javax.swing.JScrollPane scrollpane;
    private javax.swing.JButton sendButton;
    // End of variables declaration//GEN-END:variables
    
    public static void main(String args[]) {
        int version = 2;
        
        if (args != null && args.length > 0 ) {
            version = Integer.parseInt(args[0]);
        }
        
        JFrame f = new JFrame("Demo");
        
        ChatServer stub = new ChatServerStub();
        
        switch (version) {
            
            case 0: {
                f.setTitle("Blocking Demo");
                f.add(new ChatDemo(stub));
                break;
            }
            
            case 1: {
                f.setTitle("SwingWorker Demo");
                ChatDemo demo = new ChatDemo();
                ChatServer swingWorkerStub = new SwingWorkerStub(stub,demo);
                demo.setChatServer(swingWorkerStub);
                f.add(demo);
                break;
            }
            
            case 2: {
                f.setTitle("FoxTrot Demo");
                ChatServer foxTrotStub = new FoxTrotStub(stub);
                f.add(new ChatDemo(foxTrotStub));
                break;
            }
            
            case 3: {
                f.setTitle("FoxTrot Dynamic Proxy Demo");
                ChatServer foxTrotProxyStub = FoxTrotStubFactory.create(stub);
                f.add(new ChatDemo(foxTrotProxyStub));
                break;
            }
            default:
        }
        
        f.setSize(400, 300);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setVisible(true);
    }
}
